      subroutine eigen_identity( n, x, ldx )

      use eigen_libs_mod
      implicit none

      integer, intent(in)             :: n
      double precision, intent(inout) :: x(ldx,*)
      integer, intent(in)             :: ldx

      integer :: i, i_1, i_2, i_3
      integer :: j, j_1, j_2, j_3
      double precision :: t

      call eigen_loop_info( 1, n, i_2, i_3, 'Y' )
      call eigen_loop_info( 1, n, j_2, j_3, 'X' )

      do i_1=i_2,i_3
        x(1:ldx, i_1) = 0D0
        i   = eigen_translate_l2g(i_1, 'Y')
        j_1 = eigen_owner_index(i, 'X')
        if ( j_1 >= 1 ) then
          x(j_1, i_1) = 1D0
        end if
      end do

      return
      end subroutine eigen_identity

